<?php
// models/Rider.php
class Rider {
    private $conn;
    private $table_name = "riders";

    public $id;
    public $name;
    public $phone_number;
    public $branch_id;
    public $profile_picture;
    public $created_at;
    public $updated_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all riders
    public function getAll() {
        $query = "SELECT r.*, b.name as branch_name FROM " . $this->table_name . " r 
                  LEFT JOIN branches b ON r.branch_id = b.id 
                  ORDER BY r.name";
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get riders by branch ID
    public function getByBranchId($branch_id) {
        $branch_id = mysqli_real_escape_string($this->conn, $branch_id);
        $query = "SELECT * FROM " . $this->table_name . " WHERE branch_id = '$branch_id' ORDER BY name";
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get rider by ID
    public function getById($id) {
        $id = mysqli_real_escape_string($this->conn, $id);
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = '$id' LIMIT 1";
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $this->id = $row['id'];
            $this->name = $row['name'];
            $this->phone_number = $row['phone_number'];
            $this->branch_id = $row['branch_id'];
            $this->profile_picture = $row['profile_picture'];
            $this->created_at = $row['created_at'];
            $this->updated_at = $row['updated_at'];
            return true;
        }
        return false;
    }

    // Create rider
    public function create() {
        // Sanitize inputs
        $this->name = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->name)));
        $this->phone_number = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->phone_number)));
        $this->branch_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->branch_id)));
        $this->profile_picture = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->profile_picture)));
        
        $query = "INSERT INTO " . $this->table_name . " 
                  SET name='$this->name', phone_number='$this->phone_number', branch_id='$this->branch_id'";
        
        // Add profile picture if provided
        if (!empty($this->profile_picture)) {
            $query .= ", profile_picture='$this->profile_picture'";
        }
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }

    // Update rider
    public function update() {
        // Sanitize inputs
        $this->name = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->name)));
        $this->phone_number = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->phone_number)));
        $this->branch_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->branch_id)));
        $this->id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->id)));
        $this->profile_picture = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->profile_picture)));
        
        $query = "UPDATE " . $this->table_name . " 
                  SET name = '$this->name', phone_number = '$this->phone_number', branch_id = '$this->branch_id' 
                  WHERE id = '$this->id'";
        
        // Update profile picture if provided
        if (!empty($this->profile_picture)) {
            $query .= ", profile_picture = '$this->profile_picture'";
        }
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }

    // Delete rider
    public function delete() {
        $this->id = mysqli_real_escape_string($this->conn, $this->id);
        $query = "DELETE FROM " . $this->table_name . " WHERE id = '$this->id'";
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }
    
    // Get profile picture path by rider ID
    public function getProfilePicture($id) {
        $id = mysqli_real_escape_string($this->conn, $id);
        $query = "SELECT profile_picture FROM " . $this->table_name . " WHERE id = '$id' LIMIT 1";
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            return $row['profile_picture'];
        }
        return null;
    }
}
?>