# Fomax Logistics App - MySQL Migration

This document outlines the changes made to migrate the Fomax Logistics application from PDO to MySQLi and the addition of profile picture functionality for riders.

## Changes Made

1. **Database Connection**: Updated `config/database.php` to use MySQLi instead of PDO
2. **Models**: Updated all model files to use MySQLi:
   - `models/Rider.php` - Added profile_picture field and functionality
   - `models/Branch.php` - Converted to MySQLi
   - `models/User.php` - Converted to MySQLi
   - `models/Record.php` - Converted to MySQLi
   - `models/Expense.php` - Converted to MySQLi
3. **Database Schema**: Updated `fomax_logistics.sql` to include the `profile_picture` column in the riders table
4. **Admin Riders Management**: Updated `admin/riders.php` to support profile picture uploads and display

## Manual Migration Steps

Since the PHP CLI is not available in your environment, you'll need to manually execute the database migration:

1. **Add profile_picture column to riders table**:
   ```sql
   ALTER TABLE riders ADD COLUMN profile_picture VARCHAR(255) AFTER branch_id;
   ```

2. **Create uploads directory**:
   Create a directory named `uploads` in the root of the project with write permissions:
   ```
   mkdir uploads
   chmod 777 uploads
   ```

## Profile Picture Feature

The profile picture feature allows administrators to:
- Upload profile pictures when creating or updating riders
- View rider profile pictures in the riders list
- Supported formats: JPEG, PNG, GIF (max 5MB)

## File Structure

The uploaded profile pictures will be stored in the `uploads/` directory with unique filenames.

## Testing

To test the MySQL connection, you can create a simple test file or check the application functionality directly.

## Security Notes

- All user inputs are sanitized using `mysqli_real_escape_string()` and `htmlspecialchars()`
- File uploads are validated for type and size
- The uploads directory should have appropriate permissions set