<?php
// models/Record.php
class Record {
    private $conn;
    private $table_name = "records";

    public $id;
    public $rider_id;
    public $product_name;
    public $quantity;
    public $price;
    public $location;
    public $vendor_charges;
    public $payment_mode;
    public $notes;
    public $user_id;
    public $branch_id;
    public $entry_date;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all records with related data
    public function getAll($limit = null, $offset = null) {
        $query = "SELECT r.*, rid.name as rider_name, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " r
                  LEFT JOIN riders rid ON r.rider_id = rid.id
                  LEFT JOIN users u ON r.user_id = u.id
                  LEFT JOIN branches b ON r.branch_id = b.id
                  ORDER BY r.entry_date DESC";
        
        if($limit !== null && $offset !== null) {
            $offset = (int)$offset;
            $limit = (int)$limit;
            $query .= " LIMIT $offset, $limit";
        }
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get records by user ID
    public function getByUserId($user_id, $date = null) {
        $user_id = mysqli_real_escape_string($this->conn, $user_id);
        $query = "SELECT r.*, rid.name as rider_name, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " r
                  LEFT JOIN riders rid ON r.rider_id = rid.id
                  LEFT JOIN users u ON r.user_id = u.id
                  LEFT JOIN branches b ON r.branch_id = b.id
                  WHERE r.user_id = '$user_id'";
        
        if($date) {
            $date = mysqli_real_escape_string($this->conn, $date);
            $query .= " AND DATE(r.entry_date) = '$date'";
        }
        
        $query .= " ORDER BY r.entry_date DESC";
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get records by filters
    public function getByFilters($branch_id = null, $start_date = null, $end_date = null) {
        $query = "SELECT r.*, rid.name as rider_name, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " r
                  LEFT JOIN riders rid ON r.rider_id = rid.id
                  LEFT JOIN users u ON r.user_id = u.id
                  LEFT JOIN branches b ON r.branch_id = b.id
                  WHERE 1=1";
        
        if($branch_id) {
            $branch_id = mysqli_real_escape_string($this->conn, $branch_id);
            $query .= " AND r.branch_id = '$branch_id'";
        }
        
        if($start_date) {
            $start_date = mysqli_real_escape_string($this->conn, $start_date);
            $query .= " AND DATE(r.entry_date) >= '$start_date'";
        }
        
        if($end_date) {
            $end_date = mysqli_real_escape_string($this->conn, $end_date);
            $query .= " AND DATE(r.entry_date) <= '$end_date'";
        }
        
        $query .= " ORDER BY r.entry_date DESC";
        
        $result = mysqli_query($this->conn, $query);
        return $result;
    }

    // Get record by ID
    public function getById($id) {
        $id = mysqli_real_escape_string($this->conn, $id);
        $query = "SELECT r.*, rid.name as rider_name, u.username as user_name, b.name as branch_name 
                  FROM " . $this->table_name . " r
                  LEFT JOIN riders rid ON r.rider_id = rid.id
                  LEFT JOIN users u ON r.user_id = u.id
                  LEFT JOIN branches b ON r.branch_id = b.id
                  WHERE r.id = '$id' LIMIT 1";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $this->id = $row['id'];
            $this->rider_id = $row['rider_id'];
            $this->product_name = $row['product_name'];
            $this->quantity = $row['quantity'];
            $this->price = $row['price'];
            $this->location = $row['location'];
            $this->vendor_charges = $row['vendor_charges'];
            $this->payment_mode = $row['payment_mode'];
            $this->notes = $row['notes'];
            $this->user_id = $row['user_id'];
            $this->branch_id = $row['branch_id'];
            $this->entry_date = $row['entry_date'];
            return $row; // Return the full row with related data
        }
        return false;
    }

    // Create record
    public function create() {
        // Sanitize
        $this->rider_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->rider_id)));
        $this->product_name = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->product_name)));
        $this->quantity = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->quantity)));
        $this->price = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->price)));
        $this->location = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->location)));
        $this->vendor_charges = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->vendor_charges)));
        $this->payment_mode = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->payment_mode)));
        $this->notes = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->notes)));
        $this->user_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->user_id)));
        $this->branch_id = mysqli_real_escape_string($this->conn, htmlspecialchars(strip_tags($this->branch_id)));
        
        $query = "INSERT INTO " . $this->table_name . " 
                  SET rider_id='$this->rider_id', product_name='$this->product_name', quantity='$this->quantity', 
                      price='$this->price', location='$this->location', vendor_charges='$this->vendor_charges', 
                      payment_mode='$this->payment_mode', notes='$this->notes', user_id='$this->user_id', branch_id='$this->branch_id'";
        
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return mysqli_insert_id($this->conn);
        }
        return false;
    }

    // Delete record
    public function delete() {
        $this->id = mysqli_real_escape_string($this->conn, $this->id);
        $query = "DELETE FROM " . $this->table_name . " WHERE id = '$this->id'";
        $result = mysqli_query($this->conn, $query);
        
        if($result) {
            return true;
        }
        return false;
    }
    
    // Get total records count
    public function getTotalCount() {
        $query = "SELECT COUNT(*) as total FROM " . $this->table_name;
        $result = mysqli_query($this->conn, $query);
        if($result) {
            $row = mysqli_fetch_assoc($result);
            return $row['total'];
        }
        return 0;
    }
    
    // Get daily summary
    public function getDailySummary($branch_id = null, $date = null) {
        $query = "SELECT 
                    COUNT(*) as total_transactions,
                    SUM(price) as total_price,
                    SUM(vendor_charges) as total_charges,
                    SUM(price + vendor_charges) as total_revenue
                  FROM " . $this->table_name . " 
                  WHERE 1=1";
        
        if($branch_id) {
            $branch_id = mysqli_real_escape_string($this->conn, $branch_id);
            $query .= " AND branch_id = '$branch_id'";
        }
        
        if($date) {
            $date = mysqli_real_escape_string($this->conn, $date);
            $query .= " AND DATE(entry_date) = '$date'";
        }
        
        $result = mysqli_query($this->conn, $query);
        if($result && mysqli_num_rows($result) > 0) {
            return mysqli_fetch_assoc($result);
        }
        return false;
    }
}
?>