<?php
// models/Rider.php
class Rider {
    private $conn;
    private $table_name = "riders";

    public $id;
    public $name;
    public $phone_number;
    public $branch_id;
    public $created_at;
    public $updated_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all riders
    public function getAll() {
        $query = "SELECT r.*, b.name as branch_name FROM " . $this->table_name . " r 
                  LEFT JOIN branches b ON r.branch_id = b.id 
                  ORDER BY r.name";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Get riders by branch ID
    public function getByBranchId($branch_id) {
        $query = "SELECT * FROM " . $this->table_name . " WHERE branch_id = ? ORDER BY name";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $branch_id);
        $stmt->execute();
        return $stmt;
    }

    // Get rider by ID
    public function getById($id) {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $id);
        $stmt->execute();
        
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($row) {
            $this->id = $row['id'];
            $this->name = $row['name'];
            $this->phone_number = $row['phone_number'];
            $this->branch_id = $row['branch_id'];
            $this->created_at = $row['created_at'];
            $this->updated_at = $row['updated_at'];
            return true;
        }
        return false;
    }

    // Create rider
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET name=:name, phone_number=:phone_number, branch_id=:branch_id";
        
        $stmt = $this->conn->prepare($query);
        
        // Sanitize
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->phone_number = htmlspecialchars(strip_tags($this->phone_number));
        $this->branch_id = htmlspecialchars(strip_tags($this->branch_id));
        
        // Bind values
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":phone_number", $this->phone_number);
        $stmt->bindParam(":branch_id", $this->branch_id);
        
        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Update rider
    public function update() {
        $query = "UPDATE " . $this->table_name . " 
                  SET name = :name, phone_number = :phone_number, branch_id = :branch_id 
                  WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        
        // Sanitize
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->phone_number = htmlspecialchars(strip_tags($this->phone_number));
        $this->branch_id = htmlspecialchars(strip_tags($this->branch_id));
        $this->id = htmlspecialchars(strip_tags($this->id));
        
        // Bind values
        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':phone_number', $this->phone_number);
        $stmt->bindParam(':branch_id', $this->branch_id);
        $stmt->bindParam(':id', $this->id);
        
        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Delete rider
    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        
        if($stmt->execute()) {
            return true;
        }
        return false;
    }
}
?>